﻿using System;
using System.Collections.Generic;
using System.IO;
using System.Runtime.InteropServices;
using System.ComponentModel;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Globalization; // CultureInfo
using Excel = Microsoft.Office.Interop.Excel;
using System.Windows.Forms;
using System.Diagnostics;

public class CSharp
{
	static string GetColumnName(int index)
	{

		//ROUTINE TO RETURN EXCEL COLUMN LETTER FROM COLUMN INDEX
			 
		const string letters = "ABCDEFGHIJKLMNOPQRSTUVWXYZ";

		var value = "";
		if (index < 1)
		{
			throw new System.ArgumentException("Cannot call to a cell column under 1", "original");
		}
		if ( index > 16000 )
		{
			throw new System.ArgumentException("Cannot call to a cell column beyond 16000", "original");
		}
		int index1 = index;
		if ( index1 > (26*27) )
		{
			//Three letter reference
			int ref3 = ((index-1) / 26 / 26) - 1;
			value += letters[ref3];
			index1 = index1 - 26 * 26 * (ref3 + 1);
		}
		if ( index1 > 26 )
		{
			//Two letter reference
			int ref2 = ((index1-1) / 26) - 1;
			value += letters[ref2];
			index1 = index1 - 26 * (ref2 + 1);
		}
		//Single letter reference
		value += letters[index1 - 1];

		return value;
	}

	public void CSExcelComms(string OpenFileName, string SheetName, string SaveFileName, int[] int_vec, double[] xx)
	{
		/* 

			ROUTINE TO READ DATA FROM EXCEL WORKSHEET

			FileName = path-name of excel file to read from
			SheetName = name of worksheet to read from
			int_vec = vector of (integer) controls:
			xx = vector that returns read data to C++

			Routine designed so that each separate series of contiguous data require a separate call

		*/

		//Declare COM variables
		Excel.Application oXL;
		Excel.Workbooks oWBs;
		Excel.Workbook oWB;
		Excel.Sheets oSheets;
		Excel.Worksheet oSheet;
		Excel.Range oRng;
		//NOTE: these variables declared to avoid double-dot-calling expressions
		// as these prevent COM clean-up, complicating process closure.

		try
		{
			//Define working variables for analysis
			int RowStart = int_vec[0];  //index of first row to read from
			int ColStart = int_vec[1];  //index of first column to read from
			int RowNumb  = int_vec[2];   //number of rows to read from
			int ColNumb  = int_vec[3];   //number of columns to read from
			int ReadFlag = int_vec[4];  //flag=1 if read (otherwise write)
			int SaveFlag = int_vec[5];  //flag=1 if save

			
			//Start Excel and get Application object.
			oXL = new Excel.Application();
			oXL.Visible = false;
			oXL.DisplayAlerts = false;

			//Get a new workbook.
			oWBs = oXL.Workbooks;
			oWB = oWBs.Open(OpenFileName, 0, false, 5, "", "", true, Excel.XlPlatform.xlWindows, "", true, false, 0, false, true, false);

			//Get target worksheet
			oSheets = oWB.Sheets;
			oSheet = (Excel.Worksheet)oSheets[SheetName];
			oSheet.Activate();

			//Select target cells
			object CellRef1 = GetColumnName(ColStart);
			CellRef1 = CellRef1 + RowStart.ToString();
			object CellRef2 = GetColumnName(ColStart+ColNumb-1);
			CellRef2 = CellRef2 + (RowStart+RowNumb-1).ToString();
			oRng = oSheet.get_Range(CellRef1, CellRef2);

			//Read-Write opporations
			if ( ReadFlag==1 )
			{
				//Read from Excel file
				object[,] value = oRng.Value;
				for (int ii = 0; ii < RowNumb; ii++)
				{
					for (int jj = 0; jj < ColNumb; jj++)
					{
						if ( value[ii + 1, jj + 1] != null ) xx[ii + RowNumb*jj] = (double)value[ii + 1, jj + 1];
					}
				}
			}
			else
			{
				//Write to Excel file
				object[,] value = new object[RowNumb, ColNumb];
				for (int ii = 0; ii < RowNumb; ii++)
				{
					for (int jj = 0; jj < ColNumb; jj++)
					{
						value[ii, jj] = xx[ii + RowNumb * jj];
					}
				}
				oRng.Value = value;
			}

			//Exit and clean-up
			GC.Collect();
			GC.WaitForPendingFinalizers();

			//release com objects to fully kill excel process from running in the background
			Marshal.ReleaseComObject(oRng);
			Marshal.ReleaseComObject(oSheet);
			Marshal.ReleaseComObject(oSheets);

			//close and release WorkBook
			if (SaveFlag == 1) oWB.SaveAs(SaveFileName);
			oWB.Close(0);
			Marshal.ReleaseComObject(oWB);
			Marshal.ReleaseComObject(oWBs);

			//quit and release
			oXL.Quit();
			Marshal.ReleaseComObject(oXL);
		}
		catch (Exception theException)
		{
			String errorMessage;
			errorMessage = "Error: ";
			errorMessage = String.Concat(errorMessage, theException.Message);
			errorMessage = String.Concat(errorMessage, " Line: ");
			errorMessage = String.Concat(errorMessage, theException.Source);

			MessageBox.Show(errorMessage, "Error");
		}
	}
}
